<?php

declare(strict_types=1);

namespace Atlas\RandomisationBundle\Exception;

use Throwable;

final class RandomisationException extends BundleException
{
    public function __construct(string $message = 'Randomisation error', int $code = 0, ?Throwable $previous = null)
    {
        parent::__construct($message, $code, $previous);
    }

    public static function missingAlgorithm(string $type): self
    {
        return new self(sprintf('Algorithm for type: %s not found', $type));
    }
}

