<?php

declare(strict_types=1);

namespace Atlas\RandomisationBundle\Repository\Randomisation;

use Atlas\RandomisationBundle\Entity\Randomisation\InactiveRandomisation;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @extends ServiceEntityRepository<InactiveRandomisation>
 */
class InactiveRandomisationRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, InactiveRandomisation::class);
    }

    /**
     * Check if a randomisation is inactive either globally (ALL) or for a given location.
     *
     * @param string $studyCode
     * @param string $randomisationCode
     * @param string $location
     *
     * @return bool
     */
    public function check(string $studyCode, string $randomisationCode, string $location): bool
    {
        $qb = $this->createQueryBuilder('r');

        $qb->select('COUNT(r.id)')
            ->where('r.study_code = :study_code')
            ->andWhere('r.randomisation_code = :randomisation_code')
            ->andWhere($qb->expr()->in('r.location', ':locations'))
            ->setParameter('study_code', $studyCode)
            ->setParameter('randomisation_code', $randomisationCode)
            ->setParameter('locations', [$location, 'ALL']);

        $count = (int) $qb->getQuery()->getSingleScalarResult();

        return $count > 0;
    }

}
