<?php

declare(strict_types=1);

namespace Atlas\RandomisationBundle\Domain;

use Atlas\RandomisationBundle\Exception\SpecificationException;

readonly class ForceValue
{
    private(set) string $variable;
    private(set) string $value;

    /**
     * @param string $variable
     * @param string $value
     * @param int $key
     */
    public function __construct(
        string $variable,
        string $value,
        int $key
    )
    {

        if(empty($variable = mb_trim($variable, encoding: 'UTF-8'))) {
            throw new SpecificationException(sprintf('force_values[%s] variable must not be empty', $key));
        }
        //value can be empty!

        $this->variable = $variable;
        $this->value = $value;

    }
}
