<?php

namespace Atlas\RandomisationBundle\Contract;

use Atlas\ReportRenderBundle\Model\SectionInterface;
use Symfony\Component\Uid\Uuid;

interface ReportInterface
{
    /**
     * @param string $studyCode
     * @param string $randomisationCode
     * @param SpecificationInterface|null $specification
     * @param Uuid|null $simulated
     * @return SectionInterface[]
     */
    public function buildAlgorithmSections(
        string $studyCode,
        string $randomisationCode,
        ?SpecificationInterface $specification = null,
        ?Uuid $simulated = null
    ) : array;

    /**
     * @return string
     */
    public function getType(): string;
}