<?php

namespace Atlas\RandomisationBundle\Twig;

use Symfony\Component\DependencyInjection\Attribute\AutoconfigureTag;
use Symfony\Component\DependencyInjection\Attribute\Autowire;
use Twig\Extension\AbstractExtension;
use Twig\Extension\GlobalsInterface;

#[AutoconfigureTag('twig.extension')]
final class RandomisationGlobalsExtension extends AbstractExtension implements GlobalsInterface
{
    public function __construct(
        #[Autowire('%shared.randomisation.enabled%')]
        private readonly bool $enabled
    ) {}

    public function getGlobals(): array
    {
        return [
            'shared_randomisation_enabled' => $this->enabled
        ];
    }
}
