<?php

declare(strict_types=1);

namespace Atlas\RandomisationBundle\Service\Randomisation;

use Atlas\RandomisationBundle\Entity\Audit\Log as Audit;
use DateTimeInterface;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\Uid\Uuid;

readonly class RandomisationAuditor
{

    public function __construct(
        private EntityManagerInterface $entity_manager
    ) {}

    /**
     * @param string $studyCode
     * @param string $randomisationCode
     * @param string $participantIdentifier
     * @param string $message
     * @param string $actionBy
     * @param Uuid $runId
     * @param DateTimeInterface|null $simulate
     * @param Uuid|null $simulateId
     * @return void
     */
    public function log(
        string $studyCode,
        string $randomisationCode,
        string $participantIdentifier,
        string $message,
        string $actionBy,
        Uuid $runId,
        ?DateTimeInterface $simulate = null,
        ?Uuid $simulateId = null
    ): void
    {
            $audit = new Audit($studyCode, $randomisationCode, $participantIdentifier, $message, $actionBy, $runId, $simulate, $simulateId);

            $this->entity_manager->persist($audit);
            $this->entity_manager->flush();
    }
}
