<?php

declare(strict_types=1);

namespace Atlas\RandomisationBundle\Tests;

use Atlas\RandomisationBundle\RandomisationBundle;
use PHPUnit\Framework\TestCase;
use Symfony\Component\HttpKernel\Bundle\Bundle;

final class ExtensionTest extends TestCase
{
    public function test_bundle_extends_symfony_bundle(): void
    {
        $bundle = new RandomisationBundle();

        self::assertInstanceOf(Bundle::class, $bundle);
    }

    public function test_bundle_name_is_stable(): void
    {
        $bundle = new RandomisationBundle();

        self::assertSame('RandomisationBundle', $bundle->getName());
    }
}