<?php

namespace Atlas\RandomisationBundle\Service\Spreadsheet;

use PhpOffice\PhpSpreadsheet\IOFactory;
use Symfony\Component\HttpFoundation\File\UploadedFile;

class ImporterService
{
    /**
     * @return array<array<string,mixed>>  // each row as ['colName'=>value, …]
     */
    public function import(UploadedFile $file): array
    {
        $spreadsheet = IOFactory::load($file->getPathname());
        $rows        = $spreadsheet->getActiveSheet()->toArray();

        if (empty($rows) || count($rows) < 2) {
            throw new \RuntimeException('Spreadsheet must contain a header and at least one data row.');
        }

        $header   = array_map('trim', array_shift($rows));
        $dataRows = [];

        foreach ($rows as $row) {
            if (count(array_filter($row, fn($cell) => $cell !== null && $cell !== '')) === 0) {
                continue; // skip empty
            }
            $dataRows[] = array_combine($header, $row);
        }

        return $dataRows;
    }
}
