<?php

declare(strict_types=1);

namespace Atlas\RandomisationBundle\Repository\Audit;

use Atlas\RandomisationBundle\Dto\LogDto;
use Atlas\RandomisationBundle\Entity\Audit\Log;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;
use Symfony\Bridge\Doctrine\Types\UuidType;
use Symfony\Component\Uid\Uuid;

/**
 * @extends ServiceEntityRepository<Log>
 */
class LogRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, Log::class);
    }

    /**
     * @param string $studyCode
     * @param string $randomisationCode
     * @param Uuid|null $simulated
     * @return LogDto[]
     */
    public function getLogs(
        string $studyCode,
        string $randomisationCode,
        ?Uuid $simulated = null
    ): array
    {
        $qb = $this->createQueryBuilder('r');

        $qb
            ->select(
                "NEW Atlas\\RandomisationBundle\\Dto\\LogDto(
                    r.run_id,
                    r.participant_identifier,
                    r.message,
                    r.action_by,
                    r.timestamp
                )"
            )
            ->andWhere('r.study_code = :studyCode')
            ->setParameter('studyCode', $studyCode)
            ->andWhere('r.randomisation_code = :randomisationCode')
            ->setParameter('randomisationCode', $randomisationCode);

        if ($simulated !== null) {
            $qb->andWhere('r.simulation_id = :simulationId')
                ->setParameter('simulationId', $simulated, UuidType::NAME);
        } else {
            $qb->andWhere('r.simulation_id IS NULL');
        }

        $qb->orderBy('r.id', 'ASC');

        return $qb->getQuery()->getResult();
    }

    public function getParticipantLogs(
        string $studyCode,
        string $randomisationCode,
        string $participantIdentifier
    ): array
    {
        $qb = $this->createQueryBuilder('r');

        $qb
            ->select(
                "NEW Atlas\\RandomisationBundle\\Dto\\LogDto(
                    r.run_id,
                    r.participant_identifier,
                    r.message,
                    r.action_by,
                    r.timestamp
                )"
            )
            ->andWhere('r.study_code = :studyCode')
            ->setParameter('studyCode', $studyCode)
            ->andWhere('r.randomisation_code = :randomisationCode')
            ->setParameter('randomisationCode', $randomisationCode)
            ->andWhere('r.participant_identifier = :participantIdentifier')
            ->setParameter('participantIdentifier', $participantIdentifier)
            ->andWhere('r.simulation_id IS NULL')
            ->orderBy('r.id', 'ASC');

        return $qb->getQuery()->getResult();
    }
}
