<?php

declare(strict_types=1);

namespace Atlas\RandomisationBundle\Repository\Randomisation;

use Atlas\RandomisationBundle\Entity\Randomisation\Allocation;
use Atlas\RandomisationBundle\Entity\Randomisation\InactiveArm;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @extends ServiceEntityRepository<InactiveArm>
 */
class InactiveArmRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, InactiveArm::class);
    }

    /**
     * Check if an arm is inactive either globally (ALL) or for a given location.
     *
     * @param string $studyCode
     * @param string $randomisationCode
     * @param string $arm
     * @param string $location
     *
     * @return bool
     */
    public function check(string $studyCode, string $randomisationCode, string $arm, string $location): bool
    {
        $qb = $this->createQueryBuilder('a');

        $qb->select('COUNT(a.id)')
            ->where('a.study_code = :study_code')
            ->andWhere('a.randomisation_code = :randomisation_code')
            ->andWhere('a.arm = :arm')
            ->andWhere($qb->expr()->in('a.location', ':locations'))
            ->setParameter('study_code', $studyCode)
            ->setParameter('randomisation_code', $randomisationCode)
            ->setParameter('arm', $arm)
            ->setParameter('locations', [$location, 'ALL']);

        $count = (int) $qb->getQuery()->getSingleScalarResult();

        return $count > 0;
    }

}
