<?php

declare(strict_types=1);

namespace Atlas\ReportRenderBundle\Model;

use Symfony\UX\Chartjs\Model\Chart as ChartJs;

final readonly class Chart implements SectionInterface {

    public const array COLOURS = [
        '#c8102e','#d64123','#f37335','#fbb040','#ffcb77',
        '#6d1e0f','#93291e','#e94f37','#f66d44','#a14ebf',
        '#6a4c93','#0072ce','#5dade2','#4aa8a1','#009879',
        '#8dc63f','#b4d455','#cccccc','#666666','#222222'
    ];

    /**
     * @param string $title
     * @param ChartJs $chart
     * @param string $columns
     */
    public function __construct(
        private(set) string $title,
        private(set) ChartJs $chart,
        private(set) string $columns = 'col-6 col-md-6' // default 2-up layout
    ) {}

    public function getType(): string { return self::CHART; }

    /**
     * Return first $count colours from the shared Chart::COLOURS palette.
     * If $count exceeds the palette length, it will wrap around.
     */
    public static function getColours(int $count): array
    {
        $palette = Chart::COLOURS;
        $paletteSize = count($palette);

        if ($count <= $paletteSize) {
            return array_slice($palette, 0, $count);
        }

        // wrap if caller asks for more colours than we have
        $colours = [];
        for ($i = 0; $i < $count; $i++) {
            $colours[] = $palette[$i % $paletteSize];
        }

        return $colours;
    }
}