<?php

declare(strict_types=1);

namespace Atlas\ReportRenderBundle\Service;

use Atlas\ReportRenderBundle\Model\Layout;
use Symfony\Component\HttpFoundation\Response;
use Twig\Environment as Twig;

/**
 * High-level rendering facade.
 *
 * This is what your controllers (or other layers) should call.
 */
final readonly class ReportRenderer
{
    public function __construct(
        private Twig $twig
    ) {
    }

    /**
     * Render the interactive/browser HTML version.
     * Returns a Symfony Response you can just return from a controller.
     */
    public function renderHtmlResponse(Layout $layout): Response
    {
        $html = $this->twig->render('@ReportRender/report/report.html.twig', [
            'layout' => $layout,
        ]);

        return new Response($html, Response::HTTP_OK, [
            'Content-Type' => 'text/html; charset=UTF-8',
        ]);
    }
}
