<?php

declare(strict_types=1);

namespace Atlas\ReportRenderBundle\Model;

final readonly class Text implements SectionInterface {

    /**
     * @param string $text
     * @param string|null $title
     * @param bool $is_html
     * @param string $columns
     */
    public function __construct(
        private(set) string $text,
        private(set) ?string $title = null,
        private(set) bool $is_html = false,
        private(set) string $columns = 'col-6 col-md-6' // default 2-up layout
    ) {}

    public function getType(): string { return self::TEXT; }
}