<?php

declare(strict_types=1);

namespace Atlas\ReportRenderBundle\Tests\Service;

use Atlas\ReportRenderBundle\Model\Layout;
use Atlas\ReportRenderBundle\Service\ReportRenderer;
use PHPUnit\Framework\TestCase;
use Symfony\Component\HttpFoundation\Response;
use Twig\Environment;

final class ReportRendererTest extends TestCase
{
    public function test_render_html_response(): void
    {
        $twig = $this->createMock(Environment::class);

        $twig->expects(self::once())
            ->method('render')
            ->with(
                '@ReportRender/report/report.html.twig',
                self::callback(static function (array $context): bool {
                    return isset($context['layout']) && $context['layout'] instanceof Layout;
                })
            )
            ->willReturn('<html>ok</html>');

        $renderer = new ReportRenderer($twig);
        $layout = new Layout('Title');

        $response = $renderer->renderHtmlResponse($layout);

        self::assertInstanceOf(Response::class, $response);
        self::assertSame(200, $response->getStatusCode());
        self::assertStringContainsString('text/html', (string) $response->headers->get('Content-Type'));
    }
}