<?php

declare(strict_types=1);

namespace Atlas\ReportRenderBundle\Model;

use Atlas\ReportRenderBundle\Exception\ReportException;

final readonly class Table implements SectionInterface {

    /**
     * @param array $headings
     * @param array<int, array<string, mixed>> $rows
     * @param string|null $title
     * @param string $columns
     */
    public function __construct(
        private(set) array $headings,
        private(set) array $rows,
        private(set) ?string $title = null,
        private(set) string $columns = 'col-6 col-md-6' // default 2-up layout
    )
    {

        if ($rows !== []) {
            $expected = count($this->headings);
            foreach ($rows as $i => $row) {
                if (count($row) !== $expected) {
                    throw new ReportException("Row $i has ".count($row)." cells; expected $expected.");
                }
            }
        }
    }

    public function getType(): string { return self::TABLE; }
}