<?php

declare(strict_types=1);

namespace Atlas\ReportRenderBundle\Tests\Model;

use Atlas\ReportRenderBundle\Exception\ReportException;
use Atlas\ReportRenderBundle\Model\Table;
use PHPUnit\Framework\TestCase;

final class TableTest extends TestCase
{
    public function test_valid_table(): void
    {
        $table = new Table(['A', 'B'], [['1', '2']]);

        self::assertSame('table', $table->getType());
    }

    public function test_invalid_row_throws_exception(): void
    {
        $this->expectException(ReportException::class);

        new Table(['A', 'B'], [['1']]);
    }
}