<?php

declare(strict_types=1);

namespace Atlas\SecurityManagerBundle\Entity\Audit;

use Atlas\SecurityManagerBundle\Entity\User\User;
use Atlas\SecurityManagerBundle\Repository\Audit\LoginRepository;
use Atlas\AuditBundle\Attribute\NotLogged;
use DateTimeImmutable;
use DateTimeInterface;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints\Length;
use Symfony\Component\Validator\Constraints\NotBlank;


#[NotLogged]
#[ORM\Entity(repositoryClass: LoginRepository::class)]
#[ORM\Table(name: 'audit_login')]
#[ORM\Index(columns: ['user_id'])]
class Login
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private(set) ?int $id = null;

    #[ORM\Column]
    private(set) int $user_id;

    #[ORM\Column]
    private(set) int $failed_count;

    #[ORM\Column]
    private(set) bool $attempted_login;

    #[ORM\Column(length: 255)]
    #[Length(min: 10, max: 255)]
    #[NotBlank]
    private(set) string $reason;

    #[ORM\Column(type: Types::DATETIME_IMMUTABLE)]
    private(set) DateTimeInterface $timestamp;

    #[ORM\JoinColumn(name: 'user_id', referencedColumnName: 'id')]
    #[ORM\ManyToOne(targetEntity: User::class)]
    private(set) User $user;

    /**
     * @param User $user
     * @return void
     */
    public function logLoginSuccess(User $user): void
    {
        $this->user = $user;
        $this->failed_count = 0;
        $this->attempted_login = true;
        $this->reason = 'Successful login';
        $this->timestamp = new DateTimeImmutable();
    }

    /**
     * @param User $user
     * @param int $count
     * @param string $reason
     * @return void
     */
    public function logLoginFail(User $user, int $count = 1, string $reason = 'Authentication failed'): void
    {
        $this->user = $user;
        $this->failed_count = $count;
        $this->attempted_login = true;
        $this->reason = $reason;
        $this->timestamp = new DateTimeImmutable();
    }
}
