<?php
declare(strict_types=1);

namespace Atlas\SecurityManagerBundle\Exception\User;

use Atlas\SecurityManagerBundle\Exception\NotFoundException;
use Throwable;

/**
 * Thrown when a Study cannot be found.
 */
final class UserNotFoundException extends NotFoundException
{
    public function __construct(string $message = 'User not found', int $code = 0, ?Throwable $previous = null)
    {
        parent::__construct($message, $code, $previous);
    }

    public static function fromId(int $studyId): self
    {
        return new self(sprintf('User with ID %s not found', $studyId));
    }
}
