<?php

declare(strict_types=1);

namespace Atlas\SecurityManagerBundle\Security\Checker;

use Atlas\SecurityManagerBundle\Security\User as SecurityUser;
use Symfony\Component\Security\Core\Authentication\Token\TokenInterface;
use Symfony\Component\Security\Core\Exception\CustomUserMessageAccountStatusException;
use Symfony\Component\Security\Core\User\UserCheckerInterface;
use Symfony\Component\Security\Core\User\UserInterface;

class UserChecker implements UserCheckerInterface
{
    /**
     * @inheritDoc
     */
    public function checkPreAuth(UserInterface $user): void
    {
        if(! $user instanceof SecurityUser) throw new CustomUserMessageAccountStatusException('Not correct user type');
        if($user->locked) throw new CustomUserMessageAccountStatusException('User is locked');
        if(!$user->validated) throw new CustomUserMessageAccountStatusException('Account not validated');
    }

    /**
     * @inheritDoc
     */
    public function checkPostAuth(UserInterface $user, ?TokenInterface $token = null): void { } //currently we have no post auth checks
}