<?php

// src/Service/User/InternalEmailChecker.php
namespace Atlas\SecurityManagerBundle\Service\User;

use Symfony\Component\DependencyInjection\Attribute\Autowire;

final readonly class InternalEmailChecker
{
    /**
     * @param string[] $domains
     */
    public function __construct(
        #[Autowire('%security.user.internal_domains%')]
        private array $domains
    ) {}

    public function isInternal(string $email): bool
    {
        $email = mb_strtolower($email, encoding: 'UTF-8');
        foreach ($this->domains as $domain) {
            $domain = mb_strtolower(ltrim($domain, '@'), encoding: 'UTF-8');
            if (str_ends_with($email, '@'.$domain)) {
                return true;
            }
        }
        return false;
    }
}
