<?php
declare(strict_types=1);

namespace Atlas\SecurityManagerBundle\Twig\Components\Concern;

use Atlas\SecurityManagerBundle\Security\User;
use Atlas\SecurityManagerBundle\Security\User as SecurityUser;
use Symfony\Bundle\SecurityBundle\Security;
use Symfony\Component\Security\Core\Exception\AccessDeniedException;

trait SecurityUserHelperTrait
{
    private readonly Security $security;

    /**
     * @return SecurityUser
     * @throws AccessDeniedException
     */
    public function getSecurityUser(): User
    {
        $user = $this->security->getUser();
        if (!$user instanceof SecurityUser) {
            throw new AccessDeniedException('You must be logged in to access this page');
        }

        return $user;
    }
}
