<?php

// src/Validator/InternalEmailValidator.php
namespace Atlas\SecurityManagerBundle\Validator;

use Symfony\Component\DependencyInjection\Attribute\Autowire;
use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\ConstraintValidator;
use Atlas\SecurityManagerBundle\Service\User\InternalEmailChecker;

final class InternalEmailValidator extends ConstraintValidator
{

    public function __construct(
        private readonly InternalEmailChecker $checker,
        #[Autowire('%security.user.internal_as_external%')] private readonly array $internal_as_external
    )
    {}

    public function validate($value, Constraint $constraint): void
    {
        if (!$value) return;
        if (in_array(mb_strtolower($value, encoding: 'UTF-8'), $this->internal_as_external)) return; //override for
        if ($this->checker->isInternal((string)$value)) {
            $this->context->buildViolation($constraint->message)->addViolation();
        }
    }
}
