<?php

declare(strict_types=1);

namespace Atlas\SecurityManagerBundle\Doctrine\Mapping;

use Doctrine\ORM\Mapping as ORM;

trait UppercaseCodeNormaliserTrait
{
    #[ORM\PrePersist]
    #[ORM\PreUpdate]
    public function normaliseCode(): void
    {
        // guard if you ever have uninitialised / empty code during lifecycle
        if (!isset($this->code) || $this->code === '') {
            return;
        }

        $code = mb_strtoupper($this->code, 'UTF-8');

        if ($this->code !== $code) {
            $this->code = $code;
        }
    }
}
