<?php
declare(strict_types=1);

namespace Atlas\SecurityManagerBundle\Dto\User;

use Symfony\Component\Validator\Constraints as Assert;

/**
 * LDAP search result row (normalized).
 */
final class LdapUserSearchDto
{
    #[Assert\NotBlank]
    #[Assert\Length(min: 2, max: 35)]
    public ?string $identifier = null {
        // Normalize on write: trim + lowercase, tolerate null
        set => $this->identifier = $value === null ? null : trim(mb_strtolower($value));
        get => $this->identifier;
    }
}
