<?php

namespace Atlas\SecurityManagerBundle\Entity\Role;

use Atlas\AuditBundle\Attribute\AuditActor;
use Atlas\AuditBundle\Attribute\AuditTimestamp;
use Atlas\AuditBundle\Attribute\Enum\AuditActionType;
use Atlas\AuditBundle\Attribute\NotLogged;
use Atlas\SecurityManagerBundle\Doctrine\Mapping\LowercaseCodeNormaliserTrait;
use Atlas\SecurityManagerBundle\Repository\Role\PermissionRepository;
use DateTimeInterface;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Bridge\Doctrine\Validator\Constraints\UniqueEntity;
use Symfony\Component\Validator\Constraints\Length;
use Symfony\Component\Validator\Constraints\NotBlank;

#[ORM\Entity(repositoryClass: PermissionRepository::class)]
#[ORM\Table(name: 'sys_permission')]
#[UniqueEntity(fields: ['code'])]
#[ORM\HasLifecycleCallbacks]
class Permission
{
    use LowercaseCodeNormaliserTrait;

    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private(set) ?int $id = null;

    #[ORM\Column(length: 30, unique: true)]
    #[NotBlank]
    #[Length(min: 1, max: 30)]
    private(set) string $code;

    #[ORM\Column(length: 50)]
    #[NotBlank]
    #[Length(min: 2, max: 50)]
    private(set) string $name;

    #[ORM\Column(length: 500)]
    #[NotBlank]
    #[Length(min: 2, max: 500)]
    private(set) string $description;

    #[ORM\Column(nullable: true)]
    private(set) ?bool $location_restricted = null;

    #[ORM\Column]
    private(set) bool $active = false;

    #[NotLogged]
    #[ORM\Column(type: Types::DATETIME_IMMUTABLE)]
    #[AuditTimestamp(AuditActionType::INSERT)]
    private(set) DateTimeInterface $created;

    #[NotLogged]
    #[ORM\Column(length: 255)]
    #[NotBlank]
    #[AuditActor(AuditActionType::INSERT)]
    private(set) string $created_by;

    #[NotLogged]
    #[ORM\Column(type: Types::DATETIME_IMMUTABLE)]
    #[AuditTimestamp(AuditActionType::UPDATE)]
    private(set) DateTimeInterface $modified;

    #[NotLogged]
    #[ORM\Column(length: 255)]
    #[NotBlank]
    #[AuditActor(AuditActionType::UPDATE)]
    private(set) string $modified_by;

    #[ORM\Column(length: 255)]
    #[NotBlank]
    #[Length(min: 10, max: 255)]
    private(set) string $reason;

    //not database variables
    //virtual methods
    public bool $is_active {
        get => $this->active;
    }
}
