<?php

declare(strict_types=1);

namespace Atlas\SecurityManagerBundle\EventSubscriber;

use Atlas\SecurityManagerBundle\Contract\LocationInterface;
use Doctrine\Common\EventSubscriber;
use Doctrine\ORM\Events;
use Doctrine\ORM\Event\LoadClassMetadataEventArgs;
use RuntimeException;

final class LocationMetadataGuardSubscriber implements EventSubscriber
{
    public function getSubscribedEvents(): array
    {
        return [Events::loadClassMetadata];
    }

    public function loadClassMetadata(LoadClassMetadataEventArgs $args): void
    {
        $metadata = $args->getClassMetadata();

        // We only care about the concrete class that LocationInterface resolves to.
        // If the app didn't configure resolve_target_entities, this guard will never find it.
        // (You can separately hard-fail on missing resolve_target_entities if you want.)
        if (!is_a($metadata->getName(), LocationInterface::class, true)) {
            return;
        }

        // Your repo code uses l.name (ORDER BY) and you said you use code a lot.
        foreach (['id', 'name', 'lid', 'locked'] as $field) {
            if (!$metadata->hasField($field) && !$metadata->hasAssociation($field)) {
                throw new RuntimeException(sprintf(
                    'AtlasSecurityManagerBundle requires Location entity "%s" to have mapped field "%s" (used by QueryBuilder/DQL).',
                    $metadata->getName(),
                    $field
                ));
            }
        }
    }
}