<?php
declare(strict_types=1);

namespace Atlas\SecurityManagerBundle\Exception;

use Throwable;

final class LockException extends BundleException
{
    public function __construct(string $message = 'Could not complete the lock or unlocked', int $code = 0, ?Throwable $previous = null)
    {
        parent::__construct($message, $code, $previous);
    }

    public static function forResource(string $type, bool $lock): self
    {
        return new self(sprintf($lock ? '%s is already locked' : '%s is already unlocked', $type));
    }
}
