<?php
declare(strict_types=1);

namespace Atlas\SecurityManagerBundle\Exception\Role;

use Atlas\SecurityManagerBundle\Exception\NotFoundException;
use Throwable;

final class RoleNotFoundException extends NotFoundException
{
    public function __construct(string $message = 'Role not found', int $code = 0, ?Throwable $previous = null)
    {
        parent::__construct($message, $code, $previous);
    }

    public static function fromId(int $participantId): self
    {
        return new self(sprintf('Role with ID %s not found', $participantId));
    }
}
