<?php declare(strict_types=1);

namespace Atlas\SecurityManagerBundle\Form\Security;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Validator\Constraints\NotBlank;
use Symfony\Component\Validator\Exception\InvalidArgumentException;

final class PasswordRequestForm extends AbstractType
{
    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     * @return void
     * @throws InvalidArgumentException
     */
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder->add('username', TextType::class, [
            'label' => 'Username or email',
            'required' => true,
            'attr' => ['autocomplete' => 'username'],
            'constraints' => [
                new NotBlank(['message' => 'Username or email cannot be blank']),
            ],
        ]);
    }
}
