<?php

namespace Atlas\SecurityManagerBundle\Form\User;

use Atlas\SecurityManagerBundle\Dto\User\UserDto;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class ExternalUserForm extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('id', HiddenType::class)
            ->add('firstname', TextType::class, [
                'label' => 'First Name',
                'empty_data' => '',   // <- important
            ])
            ->add('lastname', TextType::class, [
                'label' => 'Last Name',
                'empty_data' => '',
            ])
            ->add('email', EmailType::class, [
                'label' => 'Email',
                'empty_data' => '',
            ]);

        if ($options['include_reason']) {
            $builder->add('reason', TextareaType::class, ['label' => 'Reason']);
        }

    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => UserDto::class,
            'include_reason' => false, // default: don't show reason
        ]);
    }
}
