<?php

namespace Atlas\SecurityManagerBundle\Form\User;

use Atlas\SecurityManagerBundle\Dto\User\LdapUserSearchDto;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class InternalUserForm extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add(
                'identifier',
                TextType::class,
                [
                    'label' => 'Username or email',
                    'required' => true,
                    'empty_data' => '',
                    'trim' => true
                ]
            );
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => LdapUserSearchDto::class, // if not binding to entity directly
        ]);
    }
}
