<?php

namespace Atlas\SecurityManagerBundle\Service\User;

use Atlas\SecurityManagerBundle\Repository\User\UserRepository;
use Symfony\Component\DependencyInjection\Attribute\Autowire;

final readonly class UsernameGenerator
{
    /**
     * @param UserRepository $user_repository
     * @param string $username_prefix
     */
    public function __construct(
        private UserRepository $user_repository,
        #[Autowire('%security.user.username_prefix%')]
        private string $username_prefix,
    ) {
    }

    /**
     * @param string $firstname
     * @param string $lastname
     * @return string
     */
    public function generate(string $firstname, string $lastname): string
    {
        $base = $this->username_prefix .
            mb_strtolower(mb_substr($firstname, 0, 1, encoding: 'UTF-8'), encoding: 'UTF-8') .
            mb_strtolower(mb_substr($lastname, 0, 1, encoding: 'UTF-8'), encoding: 'UTF-8');

        $existingCount = $this->user_repository->countUsernamesStartingWith($base);

        return $base . ($existingCount + 1);
    }
}
