<?php
declare(strict_types=1);

namespace Atlas\SecurityManagerBundle\Controller\Concern;

use Symfony\Component\HttpFoundation\Request;

trait UrlParamsTrait
{
    /**
     * Strip null (and optionally empty-string) values from query params,
     * but always keep keys you specify (default keeps 'p').
     */
    protected function urlParams(array $query, array $alwaysKeep = ['p'], bool $dropEmptyString = false): array
    {
        return array_filter(
            $query,
            static fn($v, $k) =>
                in_array($k, $alwaysKeep, true)
                || ($v !== null && (!$dropEmptyString || $v !== '')),
            ARRAY_FILTER_USE_BOTH
        );
    }

    protected function getQueryString(Request $request, array $qs = []): array
    {
        $q = $request->query;

        $norm = static function (?string $v): ?string {
            if ($v === null) {
                return null;
            }
            $v = mb_trim($v, encoding: 'UTF-8');
            return $v !== '' ? $v : null;
        };

        $c_o = $norm((string) ($q->get('o') ?? $q->get('c_o') ?? null));
        $c_d = $norm((string) ($q->get('d') ?? $q->get('c_d') ?? null));
        $c_f = $norm((string) ($q->get('f') ?? $q->get('c_f') ?? null));
        $c_s = $norm((string) ($q->get('s') ?? $q->get('c_s') ?? null));

        // p: only from request, default 1, clamp >= 1
        $p = max(1, (int) ($q->get('p') ?? 1));

        $globalQs = [
            'c_o' => $c_o,
            'c_d' => $c_d,
            'c_f' => $c_f,
            'c_s' => $c_s,
            'p'   => $p,
        ];

        return array_merge($globalQs, $qs);
    }

}
