<?php

declare(strict_types=1);

namespace Atlas\SecurityManagerBundle\Doctrine\Mapping;

use Doctrine\ORM\Mapping as ORM;

trait LowercaseCodeNormaliserTrait
{
    #[ORM\PrePersist]
    #[ORM\PreUpdate]
    public function normaliseCode(): void
    {
        // guard if you ever have uninitialised / empty code during lifecycle
        if (!isset($this->code) || $this->code === '') {
            return;
        }

        $code = mb_strtolower($this->code, 'UTF-8');

        if ($this->code !== $code) {
            $this->code = $code;
        }
    }
}
