<?php

namespace Atlas\SecurityManagerBundle\Dto\User;

use Atlas\SecurityManagerBundle\Contract\LocationInterface;
use Atlas\SecurityManagerBundle\Entity\Role\Role;
use Symfony\Component\Validator\Constraints as Assert;

class UserRoleDto
{
    public ?int $id = null;

    #[Assert\NotBlank]
    public ?Role $role = null;

    public ?LocationInterface $location = null;

    #[Assert\NotBlank]
    #[Assert\Length(min: 10, max: 255)]
    public string $reason = '';

}
