<?php
declare(strict_types=1);

namespace Atlas\SecurityManagerBundle\Exception;

use Throwable;

/**
 * Base exception for "not found" errors.
 */
class NotFoundException extends BundleException
{
    public function __construct(string $message = 'Resource not found', int $code = 0, ?Throwable $previous = null)
    {
        parent::__construct($message, $code, $previous);
    }

    public static function forId(string $resourceName, int $id): self
    {
        return new self(sprintf('%s with id %s not found', $resourceName, $id));
    }
}
