<?php
declare(strict_types=1);

namespace Atlas\SecurityManagerBundle\Exception\Validation;

use Atlas\SecurityManagerBundle\Exception\BundleException;
use Throwable;

final class NotBlankException extends BundleException
{
    public function __construct(string $message = 'Value must not be blank', int $code = 0, ?Throwable $previous = null)
    {
        parent::__construct($message, $code, $previous);
    }

    public static function forField(string $field): self
    {
        return new self($field === '' ? 'Value must not be blank' : sprintf('Field %s must not be blank', $field));
    }
}
