<?php declare(strict_types=1);

namespace Atlas\SecurityManagerBundle\Form\Security;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\PasswordType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

/**
 * Live form for password reset; no action/POST route (handled by LiveComponent).
 */
final class PasswordResetForm extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        // Field names mirror component props (password, confirm_password)
        $builder
            ->add('password', PasswordType::class, [
                'label' => 'New password',
                'required' => true,
                'attr' => [
                    'autocomplete' => 'new-password',
                ],
            ])
            ->add('confirm_password', PasswordType::class, [
                'label' => 'Confirm password',
                'required' => true,
                'attr' => [
                    'autocomplete' => 'new-password',
                ],
            ]);
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        // initial data array with keys password/confirm_password
        $resolver->setDefaults([
            'csrf_protection' => false, // LiveComponent handles requests safely
        ]);
    }
}
