<?php

declare(strict_types=1);

namespace Atlas\SecurityManagerBundle\Contract;

use Doctrine\ORM\QueryBuilder;

interface LocationRepositoryInterface
{

    /**
     * @param string|null $filter
     * @param string|null $sort
     * @param string|null $direction
     * @param string|null $search
     * @return QueryBuilder
     */
    public function findAllQueryBuilder(
        ?string $filter = null,
        ?string $sort = null,
        ?string $direction = null,
        ?string $search = null
    ): QueryBuilder;

    /**
     * @return LocationInterface[]
     */
    public function findAll(): array;

    /**
     * @param bool $activeOnly
     * @return int[]
     */
    public function findAllLocationIds(bool $activeOnly = false): array;

    /**
     * @param array $locationIds
     * @param bool $returnEntities
     * @return LocationInterface[]
     */
    public function findChildLocations(array $locationIds, bool $returnEntities = false): array;
}
