<?php
declare(strict_types=1);

namespace Atlas\SecurityManagerBundle\Dto\Role;

use Atlas\SecurityManagerBundle\Entity\Form\FormMeta;
use Atlas\SecurityManagerBundle\Entity\Role\Permission;
use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Component\Validator\Context\ExecutionContextInterface;

final class RoleDto
{
    public ?int $id = null;

    #[Assert\NotBlank]
    #[Assert\Length(min: 1, max: 25)]
    public string $code = '';

    #[Assert\NotBlank]
    #[Assert\Length(min: 2, max: 50)]
    public string $name = '';

    /** @var Permission[] */
    public array $permissions = [];

    /** @var FormMeta[] */
    public array $forms = [];

    // Same pattern as LocationDto
    public bool $include_reason = false;

    public string $reason = '';

    #[Assert\Callback]
    public function validate(ExecutionContextInterface $context): void
    {
        $includeReason = $context->getRoot()->getConfig()->getOption('include_reason') ?? false;

        if ($includeReason) {
            if (empty($this->reason)) {
                $context->buildViolation('Reason is required.')
                    ->atPath('reason')
                    ->addViolation();
            }
            elseif (mb_strlen($this->reason, encoding: 'UTF-8') < 10 || mb_strlen($this->reason, encoding: 'UTF-8') > 255) {
                $context->buildViolation('Reason must be between 10 and 255 characters.')
                    ->atPath('reason')
                    ->addViolation();
            }
        }
    }
}