<?php
declare(strict_types=1);

namespace Atlas\SecurityManagerBundle\Dto\User;

use Symfony\Component\Validator\Constraints as Assert;

/**
 * LDAP search result row (normalized).
 */
final class LdapUserDto
{
    #[Assert\NotBlank]
    public ?string $username = null;

    #[Assert\NotBlank]
    public ?string $firstname = null;

    #[Assert\NotBlank]
    public ?string $lastname = null;

    #[Assert\NotBlank]
    #[Assert\Email]
    public ?string $email = null;

}
