<?php

declare(strict_types=1);

namespace Atlas\SecurityManagerBundle\EventSubscriber;

use Atlas\SecurityManagerBundle\Contract\FormInterface;
use Doctrine\Common\EventSubscriber;
use Doctrine\ORM\Event\LoadClassMetadataEventArgs;
use Doctrine\ORM\Events;
use RuntimeException;

final class FormMetadataGuardSubscriber implements EventSubscriber
{
    public function getSubscribedEvents(): array
    {
        return [Events::loadClassMetadata];
    }

    public function loadClassMetadata(LoadClassMetadataEventArgs $args): void
    {
        $metadata = $args->getClassMetadata();

        if (!is_a($metadata->getName(), FormInterface::class, true)) {
            return;
        }

        // Match your DQL exactly
        foreach (['id', 'code', 'name', 'active'] as $field) {
            if (!$metadata->hasField($field) && !$metadata->hasAssociation($field)) {
                throw new RuntimeException(sprintf(
                    'AtlasSecurityManagerBundle requires Form entity "%s" to have mapped field "%s" (used by RoleFormRepository DQL).',
                    $metadata->getName(),
                    $field
                ));
            }
        }
    }
}
