<?php

declare(strict_types=1);

namespace Atlas\SecurityManagerBundle\Repository\Audit;

use Atlas\SecurityManagerBundle\Entity\Audit\Login;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @extends ServiceEntityRepository<Login>
 */
class LoginRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, Login::class);
    }

    /**
     * @param int $userId
     * @return Login|null
     */
    public function findLastLogin(int $userId): ?Login
    {
        return $this->createQueryBuilder('l')
            ->join('l.user', 'u')
            ->where('u.id = :identifier')
            ->setParameter('identifier', $userId)
            ->orderBy('l.timestamp', 'DESC')
            ->setMaxResults(1)
            ->getQuery()
            ->getOneOrNullResult();
    }
}
