<?php

declare(strict_types=1);

namespace Atlas\SecurityManagerBundle\DependencyInjection;

use Symfony\Component\Config\FileLocator;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Extension\Extension;
use Symfony\Component\DependencyInjection\Extension\PrependExtensionInterface;
use Symfony\Component\DependencyInjection\Loader\YamlFileLoader;

final class SecurityManagerExtension extends Extension implements PrependExtensionInterface
{
    public function load(array $configs, ContainerBuilder $container): void
    {
        $loader = new YamlFileLoader($container, new FileLocator(__DIR__ . '/../../config'));
        $loader->load('services.yaml');
    }

    /**
     * @param ContainerBuilder $container
     * @return void
     */
    public function prepend(ContainerBuilder $container): void
    {

        if ($container->hasExtension('twig')) {
            $container->loadFromExtension('twig', [
                'paths' => [
                    // path => namespace
                    __DIR__ . '/../../templates' => 'SecurityManager'
                ],
            ]);
        }

        $doctrineConfigs = $container->getExtensionConfig('doctrine');

        $defaultEm = 'default';
        $entityManagers = [];

        foreach ($doctrineConfigs as $config) {
            if (isset($config['orm']['default_entity_manager'])) {
                $defaultEm = $config['orm']['default_entity_manager'];
            }

            if (isset($config['orm']['entity_managers']) && is_array($config['orm']['entity_managers'])) {
                // later configs override earlier
                $entityManagers = array_replace($entityManagers, $config['orm']['entity_managers']);
            }
        }

        if (is_string($defaultEm)) {
            $defaultEm = trim($defaultEm);
        }

        $mappings = [
            'AtlasSecurityManager' => [
                'is_bundle' => false,
                'type' => 'attribute',
                'dir' => __DIR__ . '/../Entity',
                'prefix' => 'Atlas\SecurityManagerBundle\Entity',
                'alias' => 'AtlasSecurityManager',
            ],
        ];

        if (!isset($entityManagers[$defaultEm])) {
            // No explicit EMs defined -> old/simple projects
            $container->prependExtensionConfig('doctrine', [
                'orm' => [
                    'mappings' => $mappings,
                ],
            ]);
        } else {
            // Multi-EM project -> attach ONLY to the *configured default* EM (phoenix here)
            $container->prependExtensionConfig('doctrine', [
                'orm' => [
                    'entity_managers' => [
                        $defaultEm => [
                            'mappings' => $mappings,
                        ],
                    ],
                ],
            ]);
        }
    }
}
