<?php

namespace Atlas\SecurityManagerBundle\Entity\User;

use Atlas\AuditBundle\Attribute\NotLogged;
use Doctrine\ORM\Mapping as ORM;


use Atlas\SecurityManagerBundle\Repository\User\TwoFactorRepository;
#[ORM\Entity(repositoryClass: TwoFactorRepository::class)]
#[ORM\Table(name: 'sys_2fa_secrets')]
#[ORM\Index(columns: ['user_id'])]
#[NotLogged]
class TwoFactor
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private(set) ?int $id = null;

    #[ORM\ManyToOne(User::class)]
    #[ORM\JoinColumn(name: 'user_id', referencedColumnName: 'id')]
    private(set) User $user;

    #[ORM\Column(length: 16, nullable: true)]
    private(set) ?string $login_2fa_secret = null;

}
